implementation module iTaskLogin

//	An example how to handle a login administration
// (c) mjp 2007 

import StdEnv, StdiTasks
import loginAdmin
import iDataTrivial, iDataFormlib

derive gForm 	[]
derive gUpd 	[]

derive gForm  Login, Account, Maybe
derive gUpd   Login, Account, Maybe
derive gParse Login, Account, Maybe
derive gPrint Login, Account, Maybe
derive gerda  Login, Account
derive read   Login, Account
derive write  Login, Account

// a login procedure is a delicate thing, several users may do this at the same time while they do not have an unique id yet ...
// store *all* information in the web page of the user until it is clear who it is
// spawn a separate workflow process for every user

loginProcedure 		:: !(Task Void) !(acc -> Task acc) -> (Task ((Bool,UserId),Account acc)) | iData acc
loginProcedure  accwelcome acctask  
= 							handleLoginProcedure accwelcome acctask
	=>> \(new,acc)	->		return_V ((new,acc.uniqueId),acc) 

handleLoginProcedure :: !(Task Void) !(acc -> Task acc) -> (Task (Bool,Account acc)) | iData acc	// be very careful, several users may do this at the same time...
handleLoginProcedure accwelcome acctask 
= 				accwelcome
		#>>				(chooseTask [] 	[ ("Login", 	handleLogin)
									 	, ("New Login", newLogin acctask)
									 	]
						-||-
						buttonTask "Cancel" (return_V Nothing)
		=>> \mbacc ->	case mbacc of
							Nothing -> 					[Txt "Sorry, you have to try again!",Br,Br]
														?>> OK
												#>> 	handleLoginProcedure accwelcome acctask
							(Just result) -> 	finish result)
where	
	finish (new,acc)
		= chooseTaskV [][ ("Start Application", return_V (new,acc))
						, ("Change Login", changeLogin   acc acctask	=>> \newacc -> finish (new,newacc))
						, ("Change Amin",  changeAccount acc acctask 	=>> \newacc -> finish (new,newacc))
						]							

	handleLogin :: !(Task (Maybe (Bool,Account acc))) | iData acc
	handleLogin =						[Txt "Type in your name and password...",Br,Br]
										?>> editTask "Done" loginForm <<@ Submit
					=>>	\login ->		readAccountsDB
					=>> \accounts ->	case hasAccount login accounts of
											Nothing 	-> return_V Nothing
											(Just acc)	-> return_V (Just (False,acc))				

	newLogin :: !(acc -> Task acc) -> Task (Maybe (Bool,Account acc)) | iData acc
	newLogin acctask =						acctask	createDefault		// gather account information
						=>> 				continue					// make new login
	where
		continue acc = 						[Br, Br, Txt "Type in name and password you want to use...", Br ,Br]
											?>> editTask "Done" loginForm <<@ Submit
						=>> \login -> 		readAccountsDB
						=>> \accounts ->	case (invariantLogins "" [login:[account.login \\ account <- accounts]]) of
											(Just (_,error)) -> [Txt error, Br, Br]
																?>> continue acc
											Nothing -> 			let newaccount = {login = login, uniqueId = length accounts, state = acc} in
																addAccountsDB newaccount accounts
																=>> \_ ->	chooseTask [Txt ("You are administrated, your id = " <+++ 	length accounts)]
																			[("OK",return_V (Just (True,newaccount)))]							
	
	changeAccount::  !(Account acc) !(acc -> Task acc) -> (Task (Account acc)) | iData acc	
	changeAccount acc=:{login,uniqueId,state} acctask = newTask "changeAccount" changeAccount`
	where
		changeAccount` 
			=						acctask state
				=>> \nstate ->		readAccountsDB
				=>> \accounts ->	changeAccountsDB {acc & state = nstate} accounts
				=>> \_ ->			chooseTask [Txt ("Your administartion as been changed"),Br,toHtml nstate,Br]
									[("OK",return_V {acc & state = nstate})]			

	changeLogin :: !(Account acc) !(acc -> Task acc) -> (Task (Account acc)) | iData acc	
	changeLogin acc=:{login,uniqueId,state} acctask = newTask "changeLogin" changeLogin`
	where
		changeLogin` 
			=						[Br, Br, Txt "Type in the new name and password you want to use...", Br ,Br]
									?>> editTask "Done" loginForm <<@ Submit
				=>> \nlogin -> 		readAccountsDB
				=>> \accounts ->	case  (invariantLogins "" [nlogin:[account.login \\ account <- accounts | account.uniqueId <> uniqueId]]) of
										(Just (_,error)) -> [Txt error, Br, Br]
															?>> changeLogin acc acctask
										Nothing -> 			let newaccount = {acc & login = nlogin} in
																		changeAccountsDB newaccount accounts
															=>> \_ ->	chooseTask [Txt ("Your login as changed, your id = " <+++ 	uniqueId)]
																		[("OK",return_V newaccount)]							



loginForm :: Login
loginForm = createDefault

// utility


cancel task = task -||- buttonTask "Cancel" (return_V Nothing)

OK = buttonTask "OK" (return_V Void)

// iData database storage access utility functions

accountId :: DBid (Accounts a)
accountId	= mkDBid "loginAccount" TxtFile

readAccountsDB :: (Task (Accounts a)) | iData a
readAccountsDB = readDB accountId

readAccountDB :: !UserId -> Task (Maybe (Account a)) | iData a
readAccountDB index  
= 						readAccountsDB
	=>> \accounts ->	if (index < 0 || index >= length accounts)
							(return_V Nothing)
							(return_V (Just (accounts!!index))) 

addAccountsDB :: (Account a) (Accounts a) -> (Task (Accounts a)) | iData a
addAccountsDB acc accs
=	writeDB accountId (addAccount acc accs) 

changeAccountsDB :: (Account a) (Accounts a) -> (Task (Accounts a)) | iData a
changeAccountsDB acc accounts
=					writeDB accountId (changeAccount acc accounts) 

